<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliatesTable extends Migration {

	public function up()
	{
		Schema::create('affiliates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->boolean('active')->default(false);
			$table->double('profit_ratio')->default('0');
			$table->double('income_tax')->default('0');
			$table->json('attachments')->nullable();
			$table->string('contract_signed', 255)->nullable();
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('affiliates');
	}
}