<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonalInformationsTable extends Migration {

	public function up()
	{
		Schema::create('personal_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->date('date_of_birth');
			$table->string('nationality');
			$table->string('place_of_birth');
			$table->string('job_title_person');
			$table->integer('Age');
			$table->bigInteger('ID_number')->nullable();
			$table->enum('gender', array('Male', 'Female'));
			$table->string('Military_Status')->nullable();
			$table->string('phone');
			$table->string('mobile');
			$table->string('email_person');
			$table->string('facebook')->nullable();
			$table->string('linkedin')->nullable();
			$table->string('address');
			$table->string('website')->nullable();
			$table->string('image')->nullable();
			$table->bigInteger('cv_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('personal_informations');
	}
}