<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateYellowServicesTable extends Migration {

	public function up()
	{
		Schema::create('yellow_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->double('price');
			$table->integer('period_value')->unsigned();
			$table->enum('period_name', array('year', 'month'));
		});
	}

	public function down()
	{
		Schema::drop('yellow_services');
	}
}