<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('model_id')->unsigned();
			$table->boolean('read')->default(true);
			$table->boolean('create')->default(true);
			$table->boolean('update')->default(true);
			$table->boolean('del')->default(true);
			$table->integer('user_group_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}