<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfosTable extends Migration {

	public function up()
	{
		Schema::create('infos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('model_id')->unsigned();
			$table->string('title', 100);
			$table->text('subTitle');
			$table->text('thumbnail');
			$table->text('content');
			$table->integer('createBy')->unsigned();
			$table->string('author', 100);
			$table->integer('status');
			$table->timestamp('created');
			$table->timestamp('updated');
		});
	}

	public function down()
	{
		Schema::drop('infos');
	}
}