<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Engineer extends Eloquent {

	protected $table = 'engineer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'name', 'position', 'hr_code', 'email', 'phone', 'type_id');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function type()
	{
		return $this->belongsTo('EngineerType', 'type_id');
	}

}