<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'event';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('type_id', 'project_id', 'issuer', 'engineer_id', 'event_location', 'reference', 'description', 'category_id');

	public function type()
	{
		return $this->belongsTo('EventType', 'type_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function engineer()
	{
		return $this->belongsTo('Engineer', 'engineer_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}