<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ptw extends Eloquent {

	protected $table = 'ptw';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'project_id', 'ptw_type_id', 'time', 'ptw_location', 'company', 'note');

	public function ptw_type()
	{
		return $this->belongsTo('PtwType', 'ptw_type_id');
	}

}