<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Engineer extends Model 
{

    protected $table = 'engineer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'name', 'position', 'hr_code', 'email', 'phone', 'type_id');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function type()
    {
        return $this->belongsTo('EngineerType', 'type_id');
    }

}