<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Voc extends Model 
{

    protected $table = 'voc';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('engineer_id', 'project_id', 'note', 'date');

    public function engineer()
    {
        return $this->belongsTo('Engineer', 'engineer_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}