<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Incident extends Model 
{

    protected $table = 'incident';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'title', 'description', 'activity_id', 'type_id', 'direct_manager_id', 'time', 'investigation_team', 'incident_location', 'incident_category', 'project_id');

    public function equipments()
    {
        return $this->belongsToMany('Equipment', 'accident_equipment', 'equipment_id', 'incident_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function activity()
    {
        return $this->belongsTo('GeneralActivity', 'activity_id');
    }

    public function type()
    {
        return $this->belongsTo('IncidentType', 'type_id');
    }

    public function direct_manager()
    {
        return $this->belongsTo('Engineer', 'direct_manager_id');
    }

}