<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquipmentDetTable extends Migration {

	public function up()
	{
		Schema::create('equipment_det', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->nullable();
			$table->integer('equipment_id')->nullable();
			$table->boolean('color_code')->nullable();
			$table->datetime('insp_date')->nullable();
			$table->datetime('3party_date')->nullable();
			$table->datetime('join_date')->nullable();
			$table->datetime('date_color')->nullable();
			$table->longText('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('equipment_det');
	}
}