<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstantClosureTable extends Migration {

	public function up()
	{
		Schema::create('instant_closure', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('description')->nullable();
			$table->datetime('due_date')->nullable();
			$table->integer('responsible_id')->nullable();
			$table->datetime('closure_date')->nullable();
			$table->integer('incident_id')->nullable();
			$table->enum('type', array('preventive', 'corrective', 'recommendation'))->nullable();
			$table->enum('status', array('closed', 'ongoing', 'open'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('instant_closure');
	}
}