<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductReviewsTable extends Migration {

	public function up()
	{
		Schema::create('product_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('comment')->nullable();
			$table->tinyInteger('rating')->unsigned()->default('1');
			$table->boolean('status')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_reviews');
	}
}