<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->text('description')->nullable();
			$table->double('main_price')->nullable();
			$table->double('discount_price')->nullable();
			$table->boolean('status')->default(1);
			$table->double('store_quantity')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}