<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('city_id')->unsigned()->nullable();
			$table->text('address');
			$table->decimal('lat');
			$table->string('long');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}