<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('interests')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_type_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_lead_id_foreign');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->dropForeign('interests_parent_id_foreign');
		});
	}
}