<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Proyectos extends Eloquent {

	protected $table = 'proyectos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function members()
	{
		return $this->hasMany('Proyectos_personas');
	}

	public function createBy()
	{
		return $this->hasOne('Personas');
	}

	public function tasks()
	{
		return $this->hasMany('Tareas');
	}

}