<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarpetaTable extends Migration {

	public function up()
	{
		Schema::create('carpeta', function(Blueprint $table) {
			$table->increments('id');
			$table->string('codigoqr');
			$table->string('nro_carpeta', 200);
			$table->string('nro_expediente', 200);
			$table->string('ubicacion_gis', 200);
			$table->string('parcela', 200);
			$table->string('calle', 200);
			$table->integer('numero');
			$table->string('localidad', 200);
			$table->integer('codigo_postal');
			$table->string('fachada', 200);
			$table->string('circunscripcion', 200);
			$table->string('seccion', 200);
			$table->string('manzana', 200);
			$table->string('estado', 200);
			$table->string('obra');
			$table->string('destino');
			$table->string('agua');
			$table->string('cloacas');
			$table->string('zonificacion');
			$table->integer('superficie');
			$table->string('sello');
			$table->datetime('fecha_aprobacion');
			$table->datetime('venc_contrato');
			$table->integer('profesional_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('carpeta');
	}
}