<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropietarioTable extends Migration {

	public function up()
	{
		Schema::create('propietario', function(Blueprint $table) {
			$table->increments('id');
			$table->string('apellido', 200);
			$table->string('nombre', 200);
			$table->string('razon_social', 200);
			$table->integer('dni');
			$table->string('calle', 200);
			$table->integer('numero');
			$table->string('localidad', 200);
			$table->integer('codigo_postal');
			$table->integer('telefono');
			$table->integer('movil');
			$table->string('email', 200);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('propietario');
	}
}