<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Inspeccion extends Eloquent {

	protected $table = 'inspeccion';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function inspectores()
	{
		return $this->hasMany('App\Moron\Models\InspeccionInspector', 'inspector_id');
	}

	public function derivaciones()
	{
		return $this->hasMany('App\Moron\Models\Derivacion', 'inspeccion_id');
	}

}