<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInspeccionTable extends Migration {

	public function up()
	{
		Schema::create('inspeccion', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('fecha');
			$table->string('informe', 200);
			$table->string('tipo_inspeccion');
			$table->string('cedulas_notificacion', 200);
			$table->string('actas_comprobacion', 200);
			$table->string('foto', 500);
			$table->string('mandam_paralizado', 200);
			$table->string('acta_paralizacion', 200);
			$table->string('planilla_ini_obra', 200);
			$table->integer('derivacion_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('inspeccion');
	}
}