<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockEntryTable extends Migration {

	public function up()
	{
		Schema::create('stock_entry', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->datetime('posting_date');
			$table->bigInteger('source_warehouse_id')->unsigned();
			$table->bigInteger('target_warehouse_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->date('invoice_date')->nullable();
			$table->date('received_date')->nullable();
			$table->double('qty', 8,2);
			$table->integer('pcs')->default('0');
			$table->bigInteger('uom_id')->unsigned();
			$table->double('rate', 8,2)->nullable();
			$table->bigInteger('test_certificate_id')->unsigned();
			$table->string('plate_no')->nullable();
			$table->string('heat_no')->nullable();
			$table->string('truck_no')->nullable();
			$table->text('notes')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stock_entry');
	}
}