<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplierTable extends Migration {

	public function up()
	{
		Schema::create('supplier', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->date('member_since')->nullable();
			$table->string('contact_name')->nullable();
			$table->string('contact_no')->nullable();
			$table->string('email')->nullable();
			$table->text('notes')->nullable();
			$table->boolean('active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('supplier');
	}
}