<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('notification', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('buyer', function(Blueprint $table) {
			$table->foreign('bucket_id')->references('id')->on('bucket')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('grade_id')->references('id')->on('grade')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('finish_id')->references('id')->on('finish')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('edge_id')->references('id')->on('edge')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('uom_id')->references('id')->on('uom')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('buyer_favorite', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('buyer')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('buyer_favorite', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('enquiry', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('buyer')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('enquiry_product', function(Blueprint $table) {
			$table->foreign('enquiry_id')->references('id')->on('enquiry')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('enquiry_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('related_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('related_product', function(Blueprint $table) {
			$table->foreign('related_product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->foreign('bucket_id')->references('id')->on('bucket')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->foreign('source_warehouse_id')->references('id')->on('warehouse')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->foreign('target_warehouse_id')->references('id')->on('warehouse')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->foreign('uom_id')->references('id')->on('uom')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->foreign('test_certificate_id')->references('id')->on('test_certificate')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('notification', function(Blueprint $table) {
			$table->dropForeign('notification_user_id_foreign');
		});
		Schema::table('buyer', function(Blueprint $table) {
			$table->dropForeign('buyer_bucket_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_grade_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_finish_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_edge_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_uom_id_foreign');
		});
		Schema::table('buyer_favorite', function(Blueprint $table) {
			$table->dropForeign('buyer_favorite_buyer_id_foreign');
		});
		Schema::table('buyer_favorite', function(Blueprint $table) {
			$table->dropForeign('buyer_favorite_product_id_foreign');
		});
		Schema::table('enquiry', function(Blueprint $table) {
			$table->dropForeign('enquiry_buyer_id_foreign');
		});
		Schema::table('enquiry_product', function(Blueprint $table) {
			$table->dropForeign('enquiry_product_enquiry_id_foreign');
		});
		Schema::table('enquiry_product', function(Blueprint $table) {
			$table->dropForeign('enquiry_product_product_id_foreign');
		});
		Schema::table('related_product', function(Blueprint $table) {
			$table->dropForeign('related_product_product_id_foreign');
		});
		Schema::table('related_product', function(Blueprint $table) {
			$table->dropForeign('related_product_related_product_id_foreign');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->dropForeign('product_discount_product_id_foreign');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->dropForeign('product_discount_bucket_id_foreign');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->dropForeign('stock_entry_source_warehouse_id_foreign');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->dropForeign('stock_entry_target_warehouse_id_foreign');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->dropForeign('stock_entry_product_id_foreign');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->dropForeign('stock_entry_uom_id_foreign');
		});
		Schema::table('stock_entry', function(Blueprint $table) {
			$table->dropForeign('stock_entry_test_certificate_id_foreign');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->dropForeign('activity_user_id_foreign');
		});
	}
}