<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScheduleManagementTable extends Migration {

	public function up()
	{
		Schema::create('schedule_management', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('award_id');
			$table->tinyInteger('type');
			$table->timestamp('schedule_date');
			$table->integer('vehicle_type_id');
			$table->smallInteger('no_of_trucks')->default('1');
			$table->double('terminated_quantity')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('schedule_management');
	}
}