<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFileTable extends Migration {

	public function up()
	{
		Schema::create('File', function(Blueprint $table) {
			$table->char('id', 50)->primary();
			$table->char('class_id', 50);
			$table->char('category_id', 50);
			$table->char('pakage_id', 50);
			$table->string('name', 255);
			$table->string('slug', 255);
			$table->text('description');
			$table->string('file', 255);
			$table->string('file_type', 50);
			$table->bigInteger('price');
			$table->bigInteger('price_promotion');
			$table->string('time', 100)->nullable();
			$table->text('source');
			$table->tinyInteger('status');
			$table->char('created_by', 50);
			$table->char('updated_by', 50);
			$table->datetime('created_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('File');
	}
}