<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTopicalTable extends Migration {

	public function up()
	{
		Schema::create('topical', function(Blueprint $table) {
			$table->char('id', 50)->primary();
			$table->char('class_id', 50);
			$table->char('category_id', 50);
			$table->string('topical_group_id', 50);
			$table->char('package_id', 50);
			$table->string('name', 255);
			$table->string('slug', 255);
			$table->text('description');
			$table->bigInteger('price');
			$table->bigInteger('price_promotion');
			$table->tinyInteger('status');
			$table->char('created_by', 50);
			$table->char('updated_by', 50);
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('topical');
	}
}