<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionItemsTable extends Migration {

	public function up()
	{
		Schema::create('transaction_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('transaction_id');
			$table->integer('pet_id');
			$table->morphs('owner');
			$table->integer('price');
			$table->timestamps();
			$table->json('discount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transaction_items');
	}
}