<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('captain_register_balance')->nullable();
			$table->string('client_register_balance')->nullable();
			$table->string('captain_rate')->nullable();
			$table->string('client_rate')->nullable();
			$table->string('search_ratio')->nullable();
			$table->string('drop_out_limit')->nullable();
			$table->string('captain_drop_out_block')->nullable();
			$table->string('cancel_trip_times')->nullable();
			$table->string('client_cancel_block')->nullable();
			$table->string('free_cancel_count')->nullable();
			$table->string('client_cancel_price')->nullable();
			$table->string('captain_cancel_limit')->nullable();
			$table->string('captain_cancel_block')->nullable();
			$table->string('limit_complaints')->nullable();
			$table->string('client_lowest_dept')->nullable();
			$table->string('online_payment_tax')->nullable();
			$table->string('gift_price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}