<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('fullname')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->enum('language', array('ar', 'en'))->nullable();
			$table->string('mobile')->nullable();
			$table->string('mobile_code')->nullable();
			$table->string('verification_code')->nullable();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->enum('type', array('client', 'driver'))->nullable();
			$table->string('wallet')->nullable();
			$table->string('image')->nullable();
			$table->enum('wallet_used', array('true', 'false'))->nullable();
			$table->enum('sound', array('true', 'false'))->nullable();
			$table->enum('viberation', array('true', 'false'))->nullable();
			$table->enum('verification_status', array('true', 'false'))->nullable();
			$table->string('personal_gift')->nullable();
			$table->enum('personal_gift_status', array('true', 'false'))->nullable();
			$table->string('id_number')->nullable();
			$table->string('lat')->nullable();
			$table->string('lng')->nullable();
			$table->enum('online', array('true', 'false'))->nullable();
			$table->enum('lower_class', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}