<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaptainImagesTable extends Migration {

	public function up()
	{
		Schema::create('captain_images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('licence_number')->nullable();
			$table->string('warranty_number')->nullable();
			$table->string('id_image')->nullable();
			$table->string('investment_image')->nullable();
			$table->string('bank_account_number')->nullable();
			$table->integer('bank_id')->unsigned()->nullable();
			$table->string('iban_number')->nullable();
			$table->string('car_front_image')->nullable();
			$table->string('car_back_image')->nullable();
			$table->string('car_side_image')->nullable();
			$table->string('seats_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('captain_images');
	}
}