<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('oicofr_institute')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teachers', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('oicofr_institute')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_teacher', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_institute_id_foreign');
		});
		Schema::table('teachers', function(Blueprint $table) {
			$table->dropForeign('teachers_institute_id_foreign');
		});
		Schema::table('student_teacher', function(Blueprint $table) {
			$table->dropForeign('student_teacher_teacher_id_foreign');
		});
		Schema::table('student_teacher', function(Blueprint $table) {
			$table->dropForeign('student_teacher_student_id_foreign');
		});
	}
}