<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('dm_atom_module', function(Blueprint $table) {
			$table->foreign('atom_builder_id')->references('id')->on('dm_atom_builders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('dm_atom_module', function(Blueprint $table) {
			$table->foreign('module_builder_id')->references('id')->on('dm_module_builders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('dm_module_image', function(Blueprint $table) {
			$table->foreign('module_builder_id')->references('id')->on('dm_module_builders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('dm_module_image', function(Blueprint $table) {
			$table->foreign('image_builder_id')->references('id')->on('dm_image_builders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('dm_atom_module', function(Blueprint $table) {
			$table->dropForeign('dm_atom_module_atom_builder_id_foreign');
		});
		Schema::table('dm_atom_module', function(Blueprint $table) {
			$table->dropForeign('dm_atom_module_module_builder_id_foreign');
		});
		Schema::table('dm_module_image', function(Blueprint $table) {
			$table->dropForeign('dm_module_image_module_builder_id_foreign');
		});
		Schema::table('dm_module_image', function(Blueprint $table) {
			$table->dropForeign('dm_module_image_image_builder_id_foreign');
		});
	}
}