<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('partner_id');
			$table->integer('product_variant_id')->unsigned();
			$table->string('rating_type', 10);
			$table->integer('rating_value');
			$table->string('url', 1024)->nullable();
			$table->boolean('is_active')->default(0);
			$table->datetime('published_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}