<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Importer extends Eloquent {

	protected $table = 'importers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('last_run_at');

	public function importerLogs()
	{
		return $this->hasMany('ImporterLog');
	}

	public function currencies()
	{
		return $this->hasOne('Currency');
	}

	public function productVariantPrices()
	{
		return $this->hasMany('ProductVariantPrices');
	}

}