<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantsTable extends Migration {

	public function up()
	{
		Schema::create('product_variants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id');
			$table->string('name', 255);
			$table->string('image', 1024);
			$table->integer('sortorder');
			$table->boolean('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_variants');
	}
}