<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cms_article_id');
			$table->integer('type_id');
			$table->string('name', 255);
			$table->string('headline', 1024);
			$table->text('teaser');
			$table->text('content');
			$table->boolean('bestseller')->default(0);
			$table->datetime('released_at');
			$table->string('meta_title', 255);
			$table->string('meta_description', 255);
			$table->boolean('active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}