<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductVariant extends Eloquent {

	protected $table = 'product_variants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function productVariantPrices()
	{
		return $this->hasMany('ProductVariantPrices');
	}

	public function review()
	{
		return $this->belongsTo('Review');
	}

}