<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductVariant extends Model 
{

    protected $table = 'product_variants';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function productVariantPrices()
    {
        return $this->hasMany('ProductVariantPrices');
    }

    public function review()
    {
        return $this->belongsTo('Review');
    }

}