<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImporterLogsTable extends Migration {

	public function up()
	{
		Schema::create('importer_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('importer_id');
			$table->enum('status', array('failed', 'success'));
			$table->string('error_message', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('importer_logs');
	}
}