<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function logs()
    {
        return $this->hasMany('Log', 'login_id');
    }

    public function children()
    {
        return $this->hasMany('Child', 'login_id');
    }

    public function academies()
    {
        return $this->hasMany('Academy', 'owner_id');
    }

    public function roles()
    {
        return $this->belongsToMany('Academy', 'user_role', 'login_id')->withPivot('role');
    }

}