<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('ch_id')->unsigned();
			$table->integer('ac_id');
			$table->integer('gp_id');
			$table->string('name', 100);
			$table->string('nickname', 100)->nullable();
			$table->string('photo', 500)->nullable();
			$table->date('birthday')->nullable();
			$table->enum('gender', array('male', 'female', 'etc'));
			$table->string('postcode', 10)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('address_detail', 255)->nullable();
			$table->string('memo', 500)->nullable();
			$table->enum('status', array('pending', 'active', 'inactive'));
			$table->date('join_date')->nullable();
			$table->date('leave_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}