<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ac_id')->unsigned();
			$table->string('login_id', 100);
			$table->string('name', 100);
			$table->string('nickname', 100)->nullable();
			$table->string('photo', 500)->nullable();
			$table->enum('gender', array('male', 'female', 'etc'))->nullable();
			$table->date('birthday')->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('memo', 500)->nullable();
			$table->enum('status', array('pending', 'active', 'inactive'));
			$table->date('join_date')->nullable();
			$table->date('leave_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}