<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ac_id')->unsigned();
			$table->integer('tc_id')->unsigned();
			$table->integer('year');
			$table->string('name', 100);
			$table->string('nickname', 100)->nullable();
			$table->integer('age')->nullable();
			$table->string('memo', 255)->nullable();
			$table->enum('status', array('pending', 'active', 'inactive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}