<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('ch_id')->references('id')->on('children')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teachers', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('tc_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('edit_authority', function(Blueprint $table) {
			$table->foreign('tc_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('edit_authority', function(Blueprint $table) {
			$table->foreign('gp_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->foreign('st_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->foreign('st_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('schedule_class', function(Blueprint $table) {
			$table->foreign('sc_id')->references('id')->on('schedules')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('schedule_class', function(Blueprint $table) {
			$table->foreign('gp_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('mealplans', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('gp_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('tc_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_student', function(Blueprint $table) {
			$table->foreign('at_id')->references('id')->on('attendances')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_student', function(Blueprint $table) {
			$table->foreign('st_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_records', function(Blueprint $table) {
			$table->foreign('at_id')->references('id')->on('attendances')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attendance_records', function(Blueprint $table) {
			$table->foreign('st_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('body_records', function(Blueprint $table) {
			$table->foreign('st_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('degree_intros', function(Blueprint $table) {
			$table->foreign('ac_id')->references('id')->on('academies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_ac_id_foreign');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_ch_id_foreign');
		});
		Schema::table('teachers', function(Blueprint $table) {
			$table->dropForeign('teachers_ac_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_ac_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_tc_id_foreign');
		});
		Schema::table('edit_authority', function(Blueprint $table) {
			$table->dropForeign('edit_authority_tc_id_foreign');
		});
		Schema::table('edit_authority', function(Blueprint $table) {
			$table->dropForeign('edit_authority_gp_id_foreign');
		});
		Schema::table('families', function(Blueprint $table) {
			$table->dropForeign('families_st_id_foreign');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->dropForeign('counselings_ac_id_foreign');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->dropForeign('counselings_st_id_foreign');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->dropForeign('schedules_ac_id_foreign');
		});
		Schema::table('schedule_class', function(Blueprint $table) {
			$table->dropForeign('schedule_class_sc_id_foreign');
		});
		Schema::table('schedule_class', function(Blueprint $table) {
			$table->dropForeign('schedule_class_gp_id_foreign');
		});
		Schema::table('mealplans', function(Blueprint $table) {
			$table->dropForeign('mealplans_ac_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_gp_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_ac_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_tc_id_foreign');
		});
		Schema::table('attendance_student', function(Blueprint $table) {
			$table->dropForeign('attendance_student_at_id_foreign');
		});
		Schema::table('attendance_student', function(Blueprint $table) {
			$table->dropForeign('attendance_student_st_id_foreign');
		});
		Schema::table('attendance_records', function(Blueprint $table) {
			$table->dropForeign('attendance_records_at_id_foreign');
		});
		Schema::table('attendance_records', function(Blueprint $table) {
			$table->dropForeign('attendance_records_st_id_foreign');
		});
		Schema::table('body_records', function(Blueprint $table) {
			$table->dropForeign('body_records_st_id_foreign');
		});
		Schema::table('degree_intros', function(Blueprint $table) {
			$table->dropForeign('degree_intros_ac_id_foreign');
		});
	}
}