<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('place_type_id')->index();
			$table->string('image_path')->nullable();
			$table->string('name', 255)->index();
			$table->string('google_map_url', 500)->nullable();
			$table->jsonb('office_hours')->default('[]');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}