<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('citizen_id', 255)->index();
			$table->string('password', 255);
			$table->string('fullname', 255)->index();
			$table->datetime('birth_date');
			$table->char('gender', 1);
			$table->string('phone', 255)->index();
			$table->string('email', 255)->index();
			$table->string('card_address');
			$table->string('card_moo');
			$table->string('card_tambon');
			$table->string('card_amphoe');
			$table->string('card_province');
			$table->string('card_zipcode');
			$table->boolean('use_card_address');
			$table->string('current_address');
			$table->string('current_moo');
			$table->string('current_tambon');
			$table->string('current_district');
			$table->string('current_province');
			$table->string('current_zipcode');
			$table->string('image_path', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}