<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type')->index();
			$table->string('inform_by')->index();
			$table->string('proxy_relation')->nullable();
			$table->string('proxy_prefix')->nullable();
			$table->string('proxy_firstname')->nullable();
			$table->string('proxy_lastname')->nullable();
			$table->string('proxy_citizen_id')->nullable()->index();
			$table->string('proxy_address', 500)->nullable();
			$table->string('proxy_phone')->nullable()->index();
			$table->string('proxy_image_path')->nullable();
			$table->string('prefix');
			$table->string('firstname')->index();
			$table->string('lastname')->index();
			$table->datetime('birth_date');
			$table->string('nationality');
			$table->string('citizen_id')->index();
			$table->string('marital_status');
			$table->string('marital_text')->nullable();
			$table->string('monthly_income');
			$table->string('career')->index();
			$table->string('career_text')->nullable();
			$table->text('address');
			$table->string('phone');
			$table->string('disable_type')->nullable();
			$table->string('citizen_card_image');
			$table->string('house_registration_image');
			$table->string('disabled_card_image')->nullable();
			$table->string('refer_contact_prefix')->nullable();
			$table->string('refer_contact_firstname')->nullable();
			$table->string('refer_contact_lastname')->nullable();
			$table->string('refer_contact_phone')->nullable();
			$table->string('refer_contact_relation')->nullable();
			$table->string('welfare_status')->index();
			$table->datetime('welfare_move_date')->nullable();
			$table->string('welfare_transfer_type')->index();
			$table->string('welfare_relation')->nullable();
			$table->string('transfer_prefix')->nullable()->index();
			$table->string('transfer_firstname')->nullable()->index();
			$table->string('transfer_lastname')->nullable()->index();
			$table->string('transfer_address', 500)->nullable();
			$table->string('transfer_account_id')->index();
			$table->string('transfer_account_name')->index();
			$table->string('transfer_account_bank')->index();
			$table->string('transfer_citizen_image')->nullable();
			$table->string('transfer_house_registration_image')->nullable();
			$table->string('transfer_book_image');
			$table->datetime('reviewed_at')->nullable();
			$table->integer('reviewed_by')->nullable()->index();
			$table->boolean('is_approved')->nullable()->index();
			$table->string('rejected_reason')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}