<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('media_type');
			$table->jsonb('media_paths')->nullable();
			$table->string('title', 255)->index();
			$table->text('content');
			$table->datetime('start_at')->index();
			$table->datetime('end_at')->nullable()->index();
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}